//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit2.h"
#include "Unit1.h"
#include "RichUnit.h"
#include "SrcParser.hpp"
#include "HighLightUtils.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm2 *Form2;
//---------------------------------------------------------------------------
__fastcall TForm2::TForm2(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm2::OnChangeCBChain(TWMChangeCBChain& Message)
{
  if (Message.Remove == FClipboardOwner) FClipboardOwner =Message.Next;
  else SendMessage(FClipboardOwner, WM_CHANGECBCHAIN, (unsigned int)Message.Remove, (unsigned int)Message.Next);
  Message.Result = 0;
}

void __fastcall TForm2::OnDrawClipboard(TWMDrawClipboard& Message)
{
  SendMessage(FClipboardOwner, WM_DRAWCLIPBOARD, 0, 0);
  Message.Result = 0;
  ClipboardChanged();
}

void __fastcall TForm2::OnGetMinMaxInfo(TWMGetMinMaxInfo& Message)
{
  MaxPosition = Point(0, (Form1->Height + Form1->Top));

  Message.MinMaxInfo->ptMinTrackSize = MinTrack;        // Minimum Window Size
  Message.MinMaxInfo->ptMaxTrackSize = MaxTrack;        // Maximum Window Size
  Message.MinMaxInfo->ptMaxPosition  = MaxPosition;     // MaxPosition

  Message.Result = 0;
}


//---------------------------------------------------------------------------
void __fastcall TForm2::FormCreate(TObject *Sender)
{
  FClipboardOwner = SetClipboardViewer(Handle);
  Units = 0;
  InitializeKeywords();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormShow(TObject *Sender)
{
  NewTab();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormResize(TObject *Sender)
{
  SetEditRect();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormDestroy(TObject *Sender)
{
  ChangeClipboardChain(Handle, FClipboardOwner);
  DeInitKeywords();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  try
  {
    FileCloseAll();
  }
  catch( ... )
  {
    CanClose = false;
  }
}




void __fastcall TForm2::RichEditSelectionChange(TObject *Sender)
{
  CheckCutCopyDelete();
}

void __fastcall TForm2::RichEditChange(TObject* Sender)
{
  UpdateCursorPosition();
  SetModified(CurrentRichEdit()->Modified);
  CheckEditUndo();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::RichEditMouseDown(TObject *Sender, TMouseButton Button,
        TShiftState Shift, int X, int Y)
{
  UpdateCursorPosition();
}

void __fastcall TForm2::EditorPageControlChange(TObject *Sender)
{
  if (EditorPageControl->ActivePage != NULL)
  {
    UpdateCursorPosition();
    SetModified(CurrentRichEdit()->Modified);

    CheckEditUndo();
    CheckCutCopyDelete();
    CurrentRichEdit()->SetFocus();
  }
}

// I don't know why, but I can't get this crap to work. It just doesn't work.
// The called function UpdateInsOvw() is OK.  
//---------------------------------------------------------------------------
void __fastcall TForm2::RichEditKeyDown(TObject *Sender, WORD &Key,
        TShiftState Shift)
{
  if (Key == VK_INSERT) UpdateInsOvw();
}
//---------------------------------------------------------------------------



void __fastcall TForm2::FileOpen()
{
  if (FileOpenDlg->Execute())  LoadFile(FileOpenDlg->FileName);
}
//---------------------------------------------------------------------------
/*void __fastcall TForm2::HelpBtnClick(TObject *Sender)
{
  MessageBox(Handle, "The+Text Editor, Done by The+Intern", "The+Text Editor", MB_OK|MB_ICONINFORMATION);
}
//---------------------------------------------------------------------------
void __fastcall TForm2::ExitBtnClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
*/





  //////////// Functions included for backward compatibility
  //////////// These functions call the appropriate functions

void __fastcall TForm2::FileSaveAs()
{
  SaveFileAs();
}

void __fastcall TForm2::FileSave()		
{
  SaveFile();
}




//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  			end of Form functions										//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//				BEGIN	FILEHANDLING										//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//---------------------------------------------------------------------------

void __fastcall TForm2::SetActiveEditor(TRichEdit* Editor)
{
  EditorPageControl->ActivePage = (TTabSheet*)Editor->Parent;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::SetFileName()
{
  EditorPageControl->ActivePage->Caption = GetFileNameOnly();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::SetFileName(String FileName)
{
  CurrentRichEdit()->Hint = FileName;
  SetFileName();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::SetFileName(TRichEdit* Editor)
{
  SetActiveEditor(Editor);
  SetFileName();
}
//---------------------------------------------------------------------------
String __fastcall TForm2::GetFileName()
{
  return CurrentRichEdit()->Hint ;
}
//---------------------------------------------------------------------------
String __fastcall TForm2::GetFileName(TRichEdit* Editor)
{
  SetActiveEditor(Editor);
  return GetFileName();
}
//---------------------------------------------------------------------------
String __fastcall TForm2::GetFileNameOnly()
{
  return ExtractFileName(CurrentRichEdit()->Hint);
}
//---------------------------------------------------------------------------
void __fastcall TForm2::FindNextUnitName()
{
  for(int i =0; i < EditorPageControl->PageCount; i++)
  {
    if (Units == EditorPageControl->Pages[i]->Caption)
    {
      Units.Delete(1,4);
      int UnitNumber = Units.ToInt();
      UnitNumber++;
      Units = "Unit" + IntToStr(UnitNumber);
      FindNextUnitName();   // recurse
      break;
    }
  }
}





void __fastcall TForm2::LoadFile(AnsiString FileName)
{
  if (FileExists(FileName))
  {
    Screen->Cursor = crHourGlass;
    NewTabSheet = new TTabSheet(EditorPageControl);
    try
    {
      NewTab();

      String aExt = LowerCase(ExtractFileExt(FileName));
      if (aExt == ".pas" || aExt == ".asm" || aExt == ".cpp" || aExt == ".hpp" || aExt == ".h" || aExt == ".c")
      {
        String S = SourceToRtf(FileName,true,true);

        TMemoryStream* MyStream = new TMemoryStream();
        try
        {
          MyStream->Write(S.c_str(), S.Length());
          MyStream->Position=0;
          CurrentRichEdit()->Lines->LoadFromStream(MyStream);
        }
        catch( ... )
        {
          MyStream->Free();
          throw;
        }
        MyStream->Free();
      }
      else
      {
        CurrentRichEdit()->Lines->LoadFromFile(FileName);
      }

      SetFileName(FileName);
      CurrentRichEdit()->Modified = false;
      SetModified(false);

    }
    catch ( ... )
    {
      Screen->Cursor = crDefault;
      SetForegroundWindow(Handle);
      throw;
    }
    Screen->Cursor = crDefault;
    SetForegroundWindow(Handle);
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm2::SaveFile(AnsiString FileName)
{
    bool PlainText =CurrentRichEdit()->PlainText;
    CurrentRichEdit()->PlainText = (UpperCase(ExtractFileExt(FileName)) != ".RTF");
    CurrentRichEdit()->Lines->SaveToFile(FileName);

    CurrentRichEdit()->PlainText = PlainText;
    CurrentRichEdit()->Modified = false;
    SetModified(false);
    SetFileName(FileName);
}


void __fastcall TForm2::SaveFile()
{
  String FileName = GetFileName();
  if (! (FileExists(FileName) ))  SaveFileAs();
  else SaveFile(FileName);
}


void __fastcall TForm2::SaveFileAs()
{
  if (FileSaveDlg->Execute()) SaveFile(FileSaveDlg->FileName);
}

void __fastcall TForm2::SaveFileAs(AnsiString FileName)
{
  FileSaveDlg->FileName = FileName;
  if (FileSaveDlg->Execute()) SaveFile(FileSaveDlg->FileName);
}


void __fastcall TForm2::CheckFileSave()
{
  if (CurrentRichEdit()->Modified)
  {
    char buff[40];
    sprintf(buff, "Save changes to %s ?", GetFileName());

    int SaveResponse = (MessageBox(Handle, buff,"Confirmation", MB_YESNOCANCEL|MB_ICONQUESTION));
    switch (SaveResponse)
    {
      case ID_YES : SaveFile();
      case ID_NO :break;
      case ID_CANCEL : Abort();
    }
  }
}

void __fastcall TForm2::CheckFileSave(TRichEdit* Editor)
{
  if (Editor->Modified)
  {
    char buff[40];
    sprintf(buff, "Save changes to %s ?", GetFileName(Editor));

    int SaveResponse = (MessageBox(Handle, buff,"Confirmation", MB_YESNOCANCEL|MB_ICONQUESTION));
    switch (SaveResponse)
    {
      case ID_YES : SaveFile();
      case ID_NO :break;
      case ID_CANCEL : Abort();
    }
  }
}


void __fastcall TForm2::FileCloseAll()
{
  for(int i= EditorPageControl->PageCount-1 ; i >=0 ; i-- )
  {
    EditorPageControl->ActivePage = EditorPageControl->Pages[i];
    FileClose();
  }
}


void __fastcall TForm2::FileSaveAll()
{
  for (int i = EditorPageControl->PageCount-1; i > 0; i--)
  {
    if (GetRichEdit(i)->Modified) SaveFileAs(GetFileName(GetRichEdit(i)));
  }
}

void __fastcall TForm2::FileClose()
{
  CheckFileSave();
  EditorPageControl->ActivePage->Free();
  EditorPageControl->SelectNextPage(false);

  if (EditorPageControl->ActivePage == 0)
  {
    //Close();
//    ClientHeight = 0;
//    ClientWidth  = 0;
    DisableEditorMenuItems();
  }

}


//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  			END OF FILEHANDLING										//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//				BEGIN	MENUITEMUTILS										//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


//---------------------------------------------------------------------------

void __fastcall TForm2::UpdateCursorPosition()
{
  int iY = SendMessage(CurrentRichEdit()->Handle, EM_LINEFROMCHAR, CurrentRichEdit()->SelStart, 0);
  int iX = CurrentRichEdit()->SelStart - SendMessage(CurrentRichEdit()->Handle, EM_LINEINDEX, iY, 0);
  StatusBar->Panels->Items[0]->Text = IntToStr(iY + 1) + ':' + IntToStr(iX + 1) ;
}


void __fastcall TForm2::SetModified(bool Value)
{
  if (Value && (StatusBar->Panels->Items[1]->Text == "")) // editor is just modified
  {
    StatusBar->Panels->Items[1]->Text = "Modified";
    OnFirstModify();
  }
  else
  if ( !Value && (StatusBar->Panels->Items[1]->Text == "Modified") )// changed from modified to unmodified
  {
    StatusBar->Panels->Items[1]->Text = "";
    OnUnModify();
  }
}

void __fastcall TForm2::UpdateInsOvw()
{
  if (GetKeyState(VK_INSERT)<0)StatusBar->Panels->Items[2]->Text = "Insert";
  else StatusBar->Panels->Items[2]->Text = "Overwrite";
}

void __fastcall TForm2::CheckEditUndo()
{
  bool WasEnabled = Form1->Edit_Undo->Enabled;
  Form1->Edit_Undo->Enabled   = SendMessage(CurrentRichEdit()->Handle, EM_CANUNDO, 0, 0)!= 0;
  if ((WasEnabled) != Form1->Edit_Undo->Enabled )
  {
    Form1->Edit_Undo->Enabled = ! WasEnabled;
    Form1->TBE->SynchronizeWithMenu();
  }
}

void __fastcall TForm2::CheckCutCopyDelete()
{
  bool TextSelected = CurrentRichEdit()->SelLength > 0;

  // first menu items
  Form1->Edit_Cut->Enabled    = TextSelected;
  Form1->Edit_Copy->Enabled   = TextSelected;
  Form1->Edit_Delete->Enabled = TextSelected;
  // buttons
  Form1->TBE->SynchronizeWithMenu();

}



void __fastcall TForm2::ClipboardChanged()
{
  if (!(EditorPageControl->ActivePage == NULL))
  {
    unsigned short Format;
    bool E;
    E = False;
    for (int i=0; i< Clipboard()->FormatCount; i++)
    {
      Format = Clipboard()->Formats[i];
      if (SendMessage(CurrentRichEdit()->Handle, EM_CANPASTE, Format, 0) != 0)
      {
        E =true;
        break;
      }
    }
    if (Form1->Edit_Paste->Enabled != E)
    {
      Form1->Edit_Paste->Enabled = E;
      Form1->TBE->SynchronizeWithMenu();
    }
  }
}



void __fastcall TForm2::OnFirstModify()
{
  Form1->File_Save->Enabled = true;
  Form1->File_SaveAll->Enabled =CheckFileSaveAll();
  Form1->TBE->SynchronizeWithMenu();
}

void __fastcall TForm2::OnUnModify()
{
  Form1->File_Save->Enabled = false;
  Form1->File_SaveAll->Enabled =  CheckFileSaveAll();
  Form1->TBE->SynchronizeWithMenu();
}

bool __fastcall TForm2::CheckFileSaveAll()
{
  if (EditorPageControl->ActivePage != NULL)
  {
    for(int i=0; i< EditorPageControl->PageCount; i++)
    {
      if ( ((TRichEdit*)EditorPageControl->Pages[i]->Controls[0])->Modified)
      {
        return true;
      }
    }
  }
return false;
}



void __fastcall TForm2::DisableEditorMenuItems()
{
  Form1->Edit_Undo->Enabled = false;
  Form1->Edit_Cut->Enabled = false;
  Form1->Edit_Copy->Enabled = false;
  Form1->Edit_Paste->Enabled = false;
  Form1->Edit_Delete->Enabled = false;
  Form1->Edit_SelectAll->Enabled = false;

  Form1->File_Save->Enabled = false;
  Form1->File_SaveAs->Enabled = false;
  Form1->File_SaveAll->Enabled = false;
  Form1->File_Close->Enabled = false;
  Form1->File_CloseAll->Enabled = false;
  Form1->File_Print->Enabled = false;

  Form1->TBE->SynchronizeWithMenu();
}

void __fastcall TForm2::EnableEditorMenuItems()
{
  Form1->Edit_Undo->Enabled = true;
  Form1->Edit_Cut->Enabled = true;
  Form1->Edit_Copy->Enabled = true;
  Form1->Edit_Paste->Enabled = true;
  Form1->Edit_Delete->Enabled = true;
  Form1->Edit_SelectAll->Enabled = true;

  Form1->File_Save->Enabled = true;
  Form1->File_SaveAs->Enabled = true;
  Form1->File_SaveAll->Enabled = true;
  Form1->File_Close->Enabled = true;
  Form1->File_CloseAll->Enabled = true;
  Form1->File_Print->Enabled = true;


  CheckEditUndo();
  CheckCutCopyDelete();
  ClipboardChanged();
  UpdateInsOvw();
  SetModified(false);


  Form1->TBE->SynchronizeWithMenu();
}



//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  			END OF MENUITEMUTILS										//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//				BEGIN	RICHEDITFUNCTIONS									//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



TRichEdit* __fastcall TForm2::CurrentRichEdit(void)
{
  return (TRichEdit*)EditorPageControl->ActivePage->Controls[0];
}

TRichEdit* __fastcall TForm2::GetRichEdit(unsigned int i)
{
  return (TRichEdit*) EditorPageControl->Pages[i]->Controls[0];
}



void __fastcall TForm2::NewRichEditSetup(TRichEdit* NewRE)
{
  NewRE->Align 				= alClient;
  NewRE->Parent 			= NewTabSheet;
  NewRE->ScrollBars 	    = ssBoth;
  NewRE->HideScrollBars		= false;
  NewRE->HideSelection 		= false;
  NewRE->WordWrap			= false;
  NewRE->WantTabs 			= true;
  NewRE->ShowHint 			= false;
  NewRE->Modified 			= false;

  NewRE->Color 				= (TColor)DefaultEditorBackground;
  

  NewRE->MaxLength          = 0;
  //NewRE->SelAttributes->Name= "Courier";
  //NewRE->SelAttributes->Size = 10;
  //NewRE->DefAttributes->Name= "Courier";
  //NewRE->DefAttributes->Size = 10;

  NewRE->DefAttributes->Name = (TFontName)DefaultFontStyle;
  NewRE->DefAttributes->Size = (int)DefaultFontSize;

  Units                     = "Unit1";
  FindNextUnitName();
  NewRE->Hint               = Units;

  NewRE->OnChange 			= RichEditChange;
  NewRE->OnSelectionChange 	= RichEditSelectionChange;
  NewRE->OnKeyDown          = RichEditKeyDown;
  NewRE->OnMouseDown        = RichEditMouseDown;
  NewRE->OnKeyPress         = RichEditKeyPress;
  NewRE->OnDragOver			= RichEditDragOver;
  NewRE->OnDragDrop			= RichEditDragDrop;

}


void __fastcall TForm2::NewTab()
{

  //Create the NewTabSheet
  NewTabSheet = new TTabSheet(EditorPageControl);
  NewTabSheet->PageControl = EditorPageControl;

  //create a NewRichEdit and sets the NewTabSheet as the parent
  NewRichEdit = new TRichEdit(NewTabSheet);
  NewRichEdit->Parent = NewTabSheet;
  NewRichEdit->Align  = alClient;
  NewRichEdit->ScrollBars = ssBoth;
  NewRichEdit->WordWrap = false;
  NewRichEdit->WantTabs = true;
  NewRichEdit->HideSelection = false;
  NewRichEdit->ShowHint = false;

  NewRichEditSetup(NewRichEdit);

  //Set the NewTabSheet Properties
  EditorPageControl->ActivePage = NewTabSheet;
  EditorPageControl->ActivePage->PopupMenu = PopupMenu;
  EditorPageControl->ShowHint = false;


  SetEditRect();

  // this will not work for the file->save/saveall menuitems/buttons
  // for these to work, the application has to start off with these two disabled.
  NewRichEdit->Modified = false;
  SetModified(false);

  UpdateCursorPosition();
  CheckEditUndo();
  CheckCutCopyDelete();
  ClipboardChanged();
  UpdateInsOvw();
  SetFileName();

  NewTabSheet->Visible = true;
  NewRichEdit->Visible = true;

  CurrentRichEdit()->SetFocus();

  // check if this is the first tab
  if (EditorPageControl->PageCount == 1)
  {
    EnableEditorMenuItems();
  }
}



void __fastcall TForm2::SetEditRect()
{
  if (EditorPageControl->ActivePage != NULL)
  {
  const gutter = 20; // the gutter, shall we put this into an inifile ?

  RECT rect = { gutter, gutter, CurrentRichEdit()->Width -2 * gutter,
                CurrentRichEdit()->Height - 2 * gutter};
  SendMessage(CurrentRichEdit()->Handle, EM_SETRECT, 0, (LPARAM) &rect);
  }
}




//---------------------------------------------------------------------------
void __fastcall TForm2::Undo()
{
  CurrentRichEdit()->Perform(EM_UNDO, 0, 0);
  CurrentRichEdit()->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::Cut()
{
  PostMessage(CurrentRichEdit()->Handle, WM_CUT, 0, 0 );
  CurrentRichEdit()->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::Copy()
{
  PostMessage(CurrentRichEdit()->Handle, WM_COPY, 0, 0 );
  CurrentRichEdit()->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::Delete()
{
  CurrentRichEdit()->ClearSelection();
  CurrentRichEdit()->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::SelectAll()
{
  CurrentRichEdit()->SelectAll();
  CurrentRichEdit()->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::Paste()
{
  PostMessage(CurrentRichEdit()->Handle, WM_PASTE, 0, 0 );
  CurrentRichEdit()->SetFocus();
}
//---------------------------------------------------------------------------





void __fastcall TForm2::RichEditDragDrop(TObject *Sender, TObject *Source,
	int X, int Y)
{
  TFileListBox* Box = dynamic_cast<TFileListBox*>(Source);
  if (Box)
  {
    if (FileExists(Box->FileName))
    InsertFile(Box->FileName);
  }

  CurrentRichEdit()->SetFocus();

}
//---------------------------------------------------------------------------
void __fastcall TForm2::RichEditDragOver(TObject *Sender, TObject *Source,
	int X, int Y, TDragState State, bool &Accept)
{
    Accept = true;
}
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//  			E		N		D											//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



void __fastcall TForm2::SplitPanelMouseDown(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
  SplitPanelDragging = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm2::SplitPanelMouseMove(TObject *Sender, TShiftState Shift,
	int X, int Y)
{
  if(SplitPanelDragging)
  {
    EditorPageControl->Align = alNone;
    SplitPanel->Align = alNone;
    MessageEdit->Align = alNone;
    StatusBar->Align = alNone;
    SplitPanel->Top = SplitPanel->Top + Y  ;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::SplitPanelMouseUp(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
  if (SplitPanelDragging)
  {
    SplitPanelDragging = false;
    UpdatePanels();
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm2::UpdatePanels()
{
  MessageEdit->Top = SplitPanel->Top + SplitPanel->Height;
  MessageEdit->Height = StatusBar->Top - SplitPanel->Top - (SplitPanel->Height);

  StatusBar->Align = alBottom;
  MessageEdit->Align = alBottom;
  SplitPanel->Align = alBottom;
  EditorPageControl->Align = alClient;
}
//---------------------------------------------------------------------------

void __fastcall TForm2::PopupMenuPopup(TObject *Sender)
{
  // check all the popupitems if they have to be enabled before displaying the popup.
  PopupMenu_ClosePage->Enabled = Form1->File_Close->Enabled;
  PopupMenu_CloseAllPages->Enabled = Form1->File_CloseAll->Enabled;
  PopupMenu_New->Enabled = Form1->File_New->Enabled;
  PopupMenu_Open->Enabled = Form1->File_Open->Enabled;
  PopupMenu_Save->Enabled = Form1->File_Save->Enabled;
  PopupMenu_SaveAs->Enabled = Form1->File_SaveAs->Enabled;
  PopupMenu_SaveAll->Enabled = Form1->File_SaveAll->Enabled;
  PopupMenu_Find->Enabled = Form1->Search_Find->Enabled;
  PopupMenu_Replace->Enabled = Form1->Search_Replace->Enabled;
}

void __fastcall TForm2::PopupMenu_ClosePageClick(TObject *Sender)
{
  FileClose();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_CloseAllPagesClick(TObject *Sender)
{
  FileCloseAll();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_NewClick(TObject *Sender)
{
  NewTab();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_OpenClick(TObject *Sender)
{
  FileOpen();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_SaveClick(TObject *Sender)
{
  FileSave();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_SaveAsClick(TObject *Sender)
{
  FileSaveAs();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_SaveAllClick(TObject *Sender)
{
  FileSaveAll();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_FindClick(TObject *Sender)
{
  // Find();
}
//---------------------------------------------------------------------------
void __fastcall TForm2::PopupMenu_ReplaceClick(TObject *Sender)
{
  // Replace();
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
void __fastcall TForm2::PutEditorWindow(int top)
{

int CxScreen      = GetSystemMetrics(SM_CXSCREEN);
int CyScreen      = GetSystemMetrics(SM_CYSCREEN);
int CxFullScreen  = GetSystemMetrics(SM_CXFULLSCREEN);
int CyFullScreen  = GetSystemMetrics(SM_CYFULLSCREEN);
int CyCaption     = GetSystemMetrics(SM_CYCAPTION);
int PossibleMaxWidth  = CxScreen - (CxScreen - CxFullScreen) + 1;
int PossibleMaxHeight = CyScreen - (CyScreen - CyFullScreen) + CyCaption + 1;
div_t res = div(PossibleMaxWidth, 4);
int InsertablesMaxWidth = res.quot;

MaxPosition = Point(0, top ) ;
MinTrack    = Point(100,100);
MaxTrack    = Point(PossibleMaxWidth, PossibleMaxHeight - top);
int CurrLeft = InsertablesMaxWidth + 30;
int CurrTop  = top +10;
int CurrWidth =  PossibleMaxWidth-InsertablesMaxWidth -80 ;
int CurrHeight = PossibleMaxHeight - top - 80;
SetBounds(CurrLeft, CurrTop, CurrWidth, CurrHeight);

}

void __fastcall TForm2::PrinterSetup()
{
  PrinterSetupDlg->Execute();
}

void __fastcall TForm2::FilePrint()
{
  if (PrinterDlg->Execute())
  {
    CurrentRichEdit()->Print("");
  }

  CurrentRichEdit()->SetFocus();
}


void __fastcall TForm2::Find()
{
  FindDlg->Execute();
}

void __fastcall TForm2::Replace()
{
  ReplaceDlg->Execute();
}


void __fastcall TForm2::SearchAgain()
{
// What should go here ?
}
//---------------------------------------------------------------------------






void __fastcall TForm2::RichEditKeyPress(TObject *Sender, char &Key)
{
  if (Key == VK_INSERT) UpdateInsOvw();
  else if(   (Key == VK_SPACE) ||(Key == VK_RETURN)||  (Key == ';') || (Key == '.')||
             (Key == ',') || (Key == '(') || (Key == ')')  || (Key == '[')  || (Key == ']') ||
             (Key == ':'))
    	{
          CheckCurrentPosition() ;
        }
  else if(((Key == '+') || (Key == '-') ||
  	      ((Key >= '0') && (Key <= '9'))) && (CurrentRichEdit()->SelAttributes->Color != DefaultCommentColor)
          )
  {
    TFontStyles FStyle;
    FStyle<<fsBold;
    CurrentRichEdit()->SelAttributes->Color = (TColor)DefaultNumberColor;
    CurrentRichEdit()->SelAttributes->Style = FStyle;
    CurrentRichEdit()->SelText = Key;
    FStyle.Clear();
    CurrentRichEdit()->SelAttributes->Color = (TColor) DefaultTextColor;
    CurrentRichEdit()->SelAttributes->Style = FStyle;
    Key = 0x0;
  }
  else if (Key == 0x8) RecheckCurrentPosition();    // backspace ...

  if (Key == ';') // comment handling ...
  {
    CurrentRichEdit()->SelText = Key; // make sure the ; is printed
    ColorFromPos(CurrentRichEdit()->SelStart, (TColor) DefaultCommentColor);
    Key = 0x0;  // now fool windows ..
  }
  if (Key == VK_RETURN) // check if the commenting has to be turned off
  {
    if (CurrentRichEdit()->SelAttributes->Color == DefaultCommentColor)
    {
      TFontStyles FStyle;
      FStyle.Clear();
      CurrentRichEdit()->SelAttributes->Color = (TColor) DefaultTextColor;
      CurrentRichEdit()->SelAttributes->Style = FStyle;
    }
  }
}
//---------------------------------------------------------------------------




void __fastcall TForm2::InsertFile( AnsiString FileName)
{
  TStringList* Buf = new(TStringList);
  Buf->LoadFromFile(FileName);
  String ExtrnStatement = Buf->Strings[0];
  int p = ExtrnStatement.Pos("extrn");
  if (p != 0)
  {
    Buf->Delete(0);     //Strip EXTRN Statement
    Buf->Delete(0);     //Strip NumberOfLines
  }
  int CurrentLine = CurrentRichEdit()->Perform(EM_LINEFROMCHAR, CurrentRichEdit()->SelStart, 0);  // get the current line

  CurrentRichEdit()->Lines->BeginUpdate();
  CurrentRichEdit()->SelText = Buf->Text;   // paste the text
  delete Buf;
  // do some highlighting
  for (int i = CurrentLine; i < CurrentRichEdit()->Lines->Count; i++) ColorLine(i);
  CurrentRichEdit()->SelStart = CurrentRichEdit()->GetTextLen(); // move to end
  CurrentRichEdit()->Lines->EndUpdate();

  CurrentRichEdit()->SetFocus();
}
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

long __fastcall TForm2::GetLineNum()
{
  return SendMessage(CurrentRichEdit()->Handle, EM_LINEFROMCHAR, CurrentRichEdit()->SelStart, 0);
}

long __fastcall TForm2::GetLineStartSelIndex(long LineNum)
{
  return SendMessage(CurrentRichEdit()->Handle, EM_LINEINDEX, LineNum, 0);
}

